#ifndef AOCUTILS_H_INCLUDED
#define AOCUTILS_H_INCLUDED

#include <stdbool.h>

struct TextGrid {
    unsigned cols, rows;
    char *data; // may have '\n' at end of rows
};

long long unsigned upow(unsigned base, unsigned exponent);

void md5mini(unsigned char *dstarr, const char *src);

bool TGvalid(struct TextGrid *tg, unsigned col, unsigned row);
char *TGcharptr(struct TextGrid *tg, unsigned col, unsigned row);
unsigned TGcol(struct TextGrid *tg, char *p);
unsigned TGrow(struct TextGrid *tg, char *p);

size_t linearize2d(unsigned width, unsigned row, unsigned col); // TODO
size_t text2array(unsigned **dst, const char *txt);
size_t slurp(char **dst, const char *filename);
unsigned distance(unsigned a, unsigned b);
unsigned max3u(unsigned a, unsigned b, unsigned c);
unsigned min3u(unsigned a, unsigned b, unsigned c);

#endif
