/* *********************************************************************
Repository: https://chiselapp.com/user/nnz/repository/AdventOfCode/index
********************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "aocdailies.h" // prototypes for all aocYYYYdd functions!
#include "aocutils.h"

#define MAX_YEAR 2025

int main(int argc, char **argv) {
    unsigned y = 0, d = 0;
    char dataname[99];
    if (argc >= 3) {
        char *err;
        y = strtoul(argv[1], &err, 10);
        if (*err || (y < 2015) || (y > MAX_YEAR)) y = 0;
        d = strtoul(argv[2], &err, 10);
        if (*err || (d < 1) || (d > 25)) d = 0;
        if (argc >= 4) {
            sprintf(dataname, "%.98s", argv[3]);
        } else {
            sprintf(dataname, "inputs/%04u%02u.txt", y, d);
        }
    }
    if ((y == 0) || (d == 0)) {
        fprintf(stderr, "syntax: %s yyyy dd [input-file]\n", argv[0]);
        fprintf(stderr, "    where 2015 <= yyyy <= %d\n", MAX_YEAR);
        fprintf(stderr, "    and 1 <= dd <= 25\n");
        fprintf(stderr, "if no [input-file] is supplied loads the file inputs/yyyydd.txt\n");
        exit(EXIT_FAILURE);
    }
    // read data from dataname into input
    char *input = NULL;
    size_t ilen = slurp(&input, dataname);

    // call the right function
    aocfunc *p = aocselect(y, d);
    if (p) p(input, ilen);
    else fprintf(stderr, "Error: aoc%04u%02u() is missing.\n", y, d);
    free(input);
}
