(in-package :cl-sdm-tests)

(in-suite cl-sdm-test-suite)

(test any?
  (let ((seq '(1 2 3 4 5 6 7 8 9)))
    (is-true (sdm:any? #'plusp seq))
    (is-false (sdm:any? #'minusp seq))
    (is-true (sdm:any? #'(lambda (x)
                           (= (mod x 2) 0))
                       seq))
    (is-false (sdm:any? #'(lambda (x)
                            (> x 69))
                        seq))))

(test contains-any?
  (let ((seq1 '(1 2 3 4 5))
        (seq2 '(0 7 3 8 9))
        (seq3 '(a b c d e)))
    (is-true (sdm:contains-any? seq2 seq1))
    (is-true (sdm:contains-any? seq1 seq2))
    (is-false (sdm:contains-any? seq1 seq3))
    (is-false (sdm:contains-any? seq3 seq1))))

(test shifting
  (let ((seq1 '(a b c))
        (seq2 #(a b c)))
    (is-true (eq (sdm:shift seq1) 'a))
    (is-true (equalp seq1 '(a b c)))

    (is-true (eq (sdm:shift seq2) 'a))
    (is-true (equalp seq2 #(a b c)))

    (multiple-value-bind (element new-seq not-empty?)
        (sdm:shift seq1)
      (is-true (eq element 'a))
      (is-true (equalp new-seq '(b c)))
      (is-true not-empty?))

    (multiple-value-bind (element new-seq not-empty?)
        (sdm:shift seq2)
      (is-true (eq element 'a))
      (is-true (equalp new-seq #(b c)))
      (is-true not-empty?))

    (multiple-value-bind (element new-seq not-empty?)
        (sdm:shift '())
      (is-true (null element))
      (is-true (null new-seq))
      (is-false not-empty?))

    (multiple-value-bind (element new-seq not-empty?)
        (sdm:shift #())
      (is-true (null element))
      (is-true (equalp new-seq #()))
      (is-false not-empty?))

    (is-true (eq (sdm:shift-list seq1) 'a))
    (is-true (equalp seq1 '(a b c)))

    (multiple-value-bind (element new-seq)
        (sdm:shift-list seq1)
      (is-true (eq element 'a))
      (is-true (equalp new-seq '(b c))))

    (multiple-value-bind (element new-seq)
        (sdm:shift-list '())
      (is-true (null element))
      (is-true (null new-seq)))))

(test fill-sequence
  (let ((seq (make-array 5 :initial-element 'nil))
        (expected #(nil 1 2 3 nil)))
    (sdm:fill-sequence (seq idx :start 1 :end 4)
      idx)

    (is-true (equalp seq expected)
             "The filled sequence ~A did not equal the expected ~a" seq expected)))

(test seq-last
  (is-true (= (sdm:seq-last #(1 2 3)) 3))
  (is-false (= (sdm:seq-last #(1 2 3)) 2))
  (is-false (null (sdm:seq-last #(1 2 3))))
  (is-true (null (sdm:seq-last #())))

  (is-true (= (sdm:seq-last '(1 2 3)) 3))
  (is-false (= (sdm:seq-last '(1 2 3)) 2))
  (is-false (null (sdm:seq-last '(1 2 3))))
  (is-true (null (sdm:seq-last '()))))

(test doseq/array
  (let* ((expected '(#\a #\b #\c #\d #\e
                     #\f #\g #\h #\i #\j))
         (array (make-array 10 :element-type 'character
                               :initial-contents expected))
         (idx 0)
         (the-result nil))

    (setf the-result
          (sdm:doseq (var array :lol)
            (is-true (char= var (elt expected idx)))
            (incf idx)))

    (is-true (eql the-result :lol))))

(test doseq/list
  (let* ((expected '(#\a #\b #\c #\d #\e
                     #\f #\g #\h #\i #\j))
         (array (copy-seq expected))
         (the-idx 0)
         (the-result nil))

    (setf the-result
          (sdm:doseq (var array :lol)
            (is-true (char= var (elt expected the-idx)))
            (incf the-idx)))

    (is-true (eql the-result :lol))))
