(in-package :cl-sdm-tests)

(in-suite cl-sdm-test-suite)

(test semver/less-than
  (let ((vers (mapcar #'sdm-semver:parse-semantic-version
                      '("1.2.3-2"
                        "1.2.3-10"
                        "1.2.3-alpha"
                        "1.2.3-alpha.2"
                        "1.2.3-alpha.10"
                        "1.2.3-beta"
                        "1.2.3"
                        "1.2.4-alpha"
                        "1.2.4-beta"
                        "1.2.4"))))
    (loop for i from 1 below (1- (length vers))
          for ver1 = (elt vers (1- i))
          for ver2 = (elt vers i)
          do (is-true (sdm-semver:semver< ver1 ver2)
                      "Expected ~a to be less than ~a"
                      (sdm-semver:semver->string ver1)
                      (sdm-semver:semver->string ver2)))))

(test semver/greater-than
  (let ((vers (mapcar #'sdm-semver:parse-semantic-version
                      '("1.2.4"
                        "1.2.4-beta"
                        "1.2.4-alpha"
                        "1.2.3"
                        "1.2.3-beta"
                        "1.2.3-alpha.10"
                        "1.2.3-alpha.2"
                        "1.2.3-alpha"
                        "1.2.3-10"
                        "1.2.3-2"))))
    (loop for i from 1 below (1- (length vers))
          for ver1 = (elt vers (1- i))
          for ver2 = (elt vers i)
          do (is-true (sdm-semver:semver> ver1 ver2)
                      "Expected ~a to be less than ~a"
                      (sdm-semver:semver->string ver1)
                      (sdm-semver:semver->string ver2)))))

(test semver/equal
  (let ((vers (mapcar #'sdm-semver:parse-semantic-version
                      '("1.2.3+1"
                        "1.2.3+999"
                        "1.2.3+a"
                        "1.2.3+a.b"
                        "1.2.3+a.b.c"
                        "1.2.3"))))
    (loop for i from 0 below (1- (length vers))
          for ver1 = (elt vers i)
          for ver2 = (elt vers (1+ i))
          do (is-true (sdm-semver:semver= ver1 ver2)
                      "Expected ~a to be equal to ~a"
                      (sdm-semver:semver->string ver1)
                      (sdm-semver:semver->string ver2)))

    (loop for ver in vers do
      (is-true (sdm-semver:semver= ver ver)
               "Expected ~a to be equal to itself" (sdm-semver:semver->string ver)))))

(test semver/invalid
  (let ((vers '("1"
                "1.2"
                "1.2.3-0123"
                "1.2.3-0123.0123"
                "0.0.4--."
                "1.1.2+.123"
                "+invalid"
                "-invalid"
                "-invalid+invalid"
                "-invalid.01"
                "alpha"
                "alpha.beta"
                "alpha.beta.1"
                "alpha.1"
                "alpha+beta"
                "alpha_beta"
                "alpha."
                "alpha.."
                "1.0.0-alpha_beta"
                "-alpha."
                "1.0.0-alpha.."
                "1.0.0-alpha..1"
                "1.0.0-alpha...1"
                "01.1.1"
                "1.01.1"
                "1.1.01"
                "1.2.3.DEV"
                "1.2-SNAPSHOT"
                "1.2.31.2.3----RC-SNAPSHOT.12.09.1--..12+788"
                "1.2-RC-SNAPSHOT"
                "-1.0.3-gamma+b7718"
                "+justmeta"
                "9.8.7+meta+meta"
                "9.8.7-whatever+meta+meta"
                "99999999999999999999999.999999999999999999.99999999999999999----RC-SNAPSHOT.12.09.1--------------------------------..12")))
    (dolist (ver vers)
      (signals (sdm-semver:semver-error
                "Invalid version did not raise a SEMVER-ERROR: ~a" ver)
        (sdm-semver:parse-semantic-version ver)))))

(test semver/incf
  (let ((ver (sdm-semver:parse-semantic-version "1.0.0-alpha+deadbeef"))
        (new-ver nil))
    (setf new-ver (sdm-semver:semver-incf-major ver))
    (is-true (= (sdm-semver:semver-major new-ver) 2))
    (is-true (= (sdm-semver:semver-minor new-ver) 0))
    (is-true (= (sdm-semver:semver-revision new-ver) 0))
    (is-true (null (sdm-semver:semver-prerelease new-ver)))
    (is-true (null (sdm-semver:semver-build new-ver)))

    (setf new-ver (sdm-semver:semver-incf-minor ver))
    (is-true (= (sdm-semver:semver-major new-ver) 1))
    (is-true (= (sdm-semver:semver-minor new-ver) 1))
    (is-true (= (sdm-semver:semver-revision new-ver) 0))
    (is-true (null (sdm-semver:semver-prerelease new-ver)))
    (is-true (null (sdm-semver:semver-build new-ver)))

    (setf new-ver (sdm-semver:semver-incf-revision ver))
    (is-true (= (sdm-semver:semver-major new-ver) 1))
    (is-true (= (sdm-semver:semver-minor new-ver) 0))
    (is-true (= (sdm-semver:semver-revision new-ver) 1))
    (is-true (null (sdm-semver:semver-prerelease new-ver)))
    (is-true (null (sdm-semver:semver-build new-ver)))))

(test semver/version-core
  (loop for i from 0 to 9 do
    (is-true (sdm-semver:t/version-core-p i) "Not a T/VERSION-CORE: ~a" i))

  (is-false (typep #\a 'sdm-semver:t/version-core))
  (is-false (typep "foo" 'sdm-semver:t/version-core))
  (is-false (typep 'bar 'sdm-semver:t/version-core)))

(test semver/prerelease
  (is-true (sdm-semver:t/prerelease-p '(1 2 3)))
  (is-true (typep '(1 2 3) 'sdm-semver:t/prerelease))
  (is-true (sdm-semver:t/prerelease-p '("1a" "foo")))
  (is-true (sdm-semver:t/prerelease-p '("foo")))

  (is-false (sdm-semver:t/prerelease-p '("01")))
  (is-false (sdm-semver:t/prerelease-p '(:foo))))

(test semver/build-string
  (is-true (typep nil 'sdm-semver:t/build-string))
  (is-true (sdm-semver:t/build-string-p "a"))
  (is-true (sdm-semver:t/build-string-p "123"))
  (is-false (sdm-semver:t/build-string-p 123))
  (is-false (sdm-semver:t/build-string-p ""))
  (is-false (sdm-semver:t/build-string-p 'foo)))
