(in-package :cl-sdm-tests)

(in-suite cl-sdm-test-suite)

(test crc64-compute-with-ecma-poly
  (let ((tests '(("Hello, world!" . #x8E59E143665877C4)
                 ("Crystal" . #x6297AE23EB504638)
                 ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" . #x8ED7EFB6C22BE2D6))))
    (sdm:with-crc64 (crc)
      (is-true (= (sdm:crc64-polynomial crc) sdm:+crc64-ecma-polynomial+) "ECMA polynomial is not the default")
      (is-true (= (sdm:crc64-crc crc) 0) "Initial CRC value is not zero")

      (dolist (pair tests)
        (is-true (= (sdm:crc64-crc crc) 0) "CRC value is not zero")
        (is-true (= (sdm:crc64-update crc (car pair)) (cdr pair))
                 "Failed to check pair: ~s != ~a" (car pair) (cdr pair))
        (sdm:crc64-reset crc)
        (is-true (= (sdm:crc64-crc crc) 0) "CRC value is not zero after reset"))

      (dolist (pair tests)
        (is-true (= (sdm:crc64-crc crc) 0) "CRC value is not zero")
        (is-true (= (sdm:crc64-update crc (sdm:string->bytes (car pair))) (cdr pair))
                 "Failed to check pair: ~s != ~a" (car pair) (cdr pair))
        (sdm:crc64-reset crc)
        (is-true (= (sdm:crc64-crc crc) 0) "CRC value is not zero after reset")))))

(test crc64-compute-with-iso-poly
  (let ((tests '(("Hello, world!" . #xD176C45C2611D9C2)
                 ("Crystal" . #x3EE4087C628DF140)
                 ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" . #x37F1F22DFB885401))))
    (sdm:with-crc64 (crc)
      (is-true (= (sdm:crc64-polynomial crc) sdm:+crc64-ecma-polynomial+) "ECMA polynomial is not the default")
      (is-true (= (sdm:crc64-crc crc) 0) "Initial CRC value is not zero")

      (setf (sdm:crc64-polynomial crc) sdm:+crc64-iso-polynomial+)

      (sdm:crc64-update crc 69)
      (is-true (/= (sdm:crc64-crc crc) 0) "CRC is 0 despite hashing a value that should not be 0")
      (sdm:crc64-reset crc)
      (is-true (= (sdm:crc64-crc crc) 0) "CRC value is not back to zero after reset")

      (is-true (= (sdm:crc64-polynomial crc) sdm:+crc64-iso-polynomial+)
               "Polynomial is not the ISO polynomial after setting")

      (dolist (pair tests)
        (is-true (= (sdm:crc64-crc crc) 0) "CRC value is not zero")
        (is-true (= (sdm:crc64-update crc (car pair)) (cdr pair))
                 "Failed to check pair: ~s != ~a" (car pair) (cdr pair))
        (sdm:crc64-reset crc)
        (is-true (= (sdm:crc64-crc crc) 0) "CRC value is not zero after reset")))))
