(in-package :cl-sdm-tests)

(in-suite cl-sdm-test-suite)

(test xor
  (is-true (sdm:xor t nil))
  (is-true (sdm:xor nil t))
  (is-false (sdm:xor t t))
  (is-false (sdm:xor nil nil)))

(test hash-table-contains-p
  (let  ((to-contain (loop for i from 0 to 42 collect (random 9001) into ret finally (remove-duplicates ret)))
         (table (make-hash-table)))
    (dolist (contains to-contain)
      (setf (gethash contains table) t))

    (dolist (contains to-contain)
      (unless (sdm:hash-table-contains-p table contains)
        (fail "The hash table did not contain the expected value ~a" contains)))

    (loop for i from 8000 to 9100
          unless (find i to-contain :test #'=) do
            (when (sdm:hash-table-contains-p table i)
              (fail "The hash table unexpectedly contained the value ~a" i)))))

(test hash-let
  (let ((table (make-hash-table :test 'equal))
        (val-1 (random 9001))
        (val-2 (random 9001))
        (val-3 (random 9001)))
    (setf (gethash "key 1" table) val-1)
    (setf (gethash "key 2" table) val-2)
    (setf (gethash "key 3" table) val-3)

    (sdm:hash-let table ((test-val-1 "key 1")
                         (test-val-2 "key 2" 2-was-found)
                         (test-val-3 "key 3")
                         (test-val-4 "key 69" nice-key-was-found))
      (is-true (= test-val-1 val-1))
      (is-true (= test-val-2 val-2))
      (is-true (= test-val-3 val-3))
      (is-true 2-was-found)
      (is-false nice-key-was-found)
      (is-true (null test-val-4)))))

(test hash-try-add
  (let ((table (make-hash-table :test 'equal)))
    (is-false (gethash "test" table))
    (is-true (sdm:hash-try-add table "test" 36))
    (is-true (= (gethash "test" table) 36))
    (is-true (sdm:hash-try-add table "test 2" 69))
    (is-false (sdm:hash-try-add table "test" 9))))

(test parse-integer?
  (is-true (= (sdm:parse-integer? "69") 69))
  (is-true (= (sdm:parse-integer? "69 ") 69))
  (is-true (= (sdm:parse-integer? " 69 ") 69))
  (is-true (= (sdm:parse-integer? " 69") 69))

  (is-true (null (sdm:parse-integer? "69a")))

  (is-true (null (sdm:parse-integer? "2a")))
  (is-true (= (sdm:parse-integer? "2a" :radix 16) 42))

  (is-true (= (sdm:parse-integer? "lol69a" :start 3 :end 5) 69))
  (is-true (null (sdm:parse-integer? "lol69a" :start 2 :end 5)))
  (is-true (null (sdm:parse-integer? "lol69a" :start 3))))

(test binding-multiple-values
  (sdm:binding-multiple-values (((a b c) (values 1 2 3))
                                ((foo bar baz) (values 'a 'b 'c)))
    (is-true (= a 1))
    (is-true (= b 2))
    (is-true (= c 3))
    (is-true (eq foo 'a))
    (is-true (eq bar 'b))
    (is-true (eq baz 'c))))

(defun close-to (expected actual delta)
  (if (equal actual expected)
      t
      (let ((diff (abs (- actual expected))))
        (<= diff delta))))
