(in-package :cl-sdm-tests)

(in-suite cl-sdm-test-suite)

(test array-pool-renting-and-returning
  (let ((pool (sdm:make-array-pool 'fixnum 0)))
    (sdm:with-rented-array (a1 5 pool)
      (is-true (equalp a1 #(0 0 0 0 0)))
      (setf (aref a1 1) 69)
      (is-true (equalp a1 #(0 69 0 0 0)))

      (sdm:with-rented-array (a2 5 pool)
        (setf (aref a2 1) 42)
        (is-true (equalp a1 #(0 69 0 0 0)))
        (is-true (equalp a2 #(0 42 0 0 0))))

      (is-true (equalp a1 #(0 69 0 0 0)))
      (sdm:with-rented-array (a2 5 pool)
        (setf (aref a2 1) 36)
        (is-true (equalp a1 #(0 69 0 0 0)))
        (is-true (equalp a2 #(0 36 0 0 0))))
      (is-true (equalp a1 #(0 69 0 0 0))))))
