;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm/uds)

;;;;
;;;; Socket Classes
;;;;

(defclass socket ()
  ((filename
    :type pathname
    :reader socket-filename)

   (type
    :type t/socket-type
    :reader socket-type)

   (keepalive?
    :type boolean
    :reader socket-keepalive-p)

   (read-timeout
    :initform 0
    :type t/read-timeout
    :reader socket-read-timeout)

   (open?
    :type boolean
    :reader socket-open-p)

   (impl))
  (:documentation "The base class for all sockets.  Instances of this should
never be instantiated directly; use MAKE-SERVER-SOCKET or MAKE-CLIENT-SOCKET
instead."))

(defclass server-socket (socket)
  ()
  (:documentation "A socket that listens for connections.  Note that
communication doesn't happen over a SERVER-SOCKET directly, and instead happens
over CLIENT-SOCKET instances that are spawned from it using SOCKET-ACCEPT."))

(defclass client-socket (socket
                         trivial-gray-streams:fundamental-binary-input-stream
                         trivial-gray-streams:fundamental-binary-output-stream)
  ((strm))
  (:documentation "A socket that connects to another socket and is used for
communication."))
