;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;;;
;;;; Package Definition
;;;;

(defpackage :cl-sdm/uds
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-uds)
  (:shadowing-import-from :common-lisp #:write-string)
  (:documentation "A simple wrapper library to provide access to local domain sockets (aka, UNIX domain sockets).  Part of CL-SDM.")
  (:export
   ;; socket.lisp
   #:t/socket-type
   #:t/read-timeout
   #:socket-close
   #:socket-accept
   #:socket-filename
   #:socket-type
   #:socket-open-p
   #:socket-keepalive-p
   #:socket-read-timeout
   #:socket
   #:server-socket
   #:client-socket

   ;; common-fn.lisp
   #:make-server-socket
   #:make-client-socket
   #:with-server
   #:with-client
   #:with-accept))
