;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm/uds)

;;;;
;;;; Core API
;;;;

(deftype t/socket-type ()
  "Defines the type of a socket, where :STREAM is stream-oriented socket, while
:DATAGRAM is used for datagrams."
  '(member :stream :datagram))

(deftype t/read-timeout ()
  "Defines a timeout, in seconds, for read operations."
  '(integer 0 1000000))

(defgeneric socket-close (socket)
  (:documentation "Closes the socket connection."))

(defgeneric socket-accept (socket)
  (:documentation "Listens for a new connection.  When one is established, this
returns a new CLIENT-SOCKET instance."))

(defgeneric socket-filename (socket)
  (:documentation "Returns the filename associated with this socket."))

(defgeneric socket-type (socket)
  (:documentation "Returns the T/SOCKET-TYPE of this socket."))

(defgeneric socket-open-p (socket)
  (:documentation "Returns T if the socket is open, or NIL if it has been
closed."))

(defgeneric socket-keepalive-p (socket)
  (:documentation "Returns T if the connection is kept active using a periodic
message transmission, or NIL otherwise."))

(defgeneric socket-read-timeout (socket)
  (:documentation "Returns the number of seconds that read operations will wait
before timing out.  For SERVER-SOCKET instances, the CLIENT-SOCKETs that are
spawned from it inherit this value.  A value of 0 means to wait indefinitely."))
