;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/time
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-time)
  (:shadowing-import-from :cl :write-string)
  (:export
   ;; functions.lisp
   #:t/day-of-week
   #:+month-names+
   #:+short-month-names+
   #:+day-names+
   #:+short-day-names+
   #:+unix-time-offset+
   #:leap-year-p
   #:t/day-of-week->num
   #:num->t/day-of-week
   #:day-num->name
   #:t/day-of-week->name
   #:day-name->num
   #:month-num->name
   #:month-name->num
   #:days-in-month
   #:universal-time->unix
   #:unix->universal-time
   #:get-now-unix-time

   ;; timespan.lisp
   #:ts-seconds
   #:ts-minutes
   #:ts-hours
   #:ts-days
   #:ts+
   #:ts-
   #:timespan
   #:make-timespan
   #:make-timespan-from-total-seconds
   #:ts-total-seconds
   #:ts-total-minutes
   #:ts-total-hours
   #:ts+/minutes
   #:ts+/hours
   #:ts+/days
   #:ts-/minutes
   #:ts-/hours
   #:ts-/days
   #:ts=
   #:ts<
   #:ts<=
   #:ts>
   #:ts>=

   ;; datetime.lisp
   #:dt-second
   #:dt-minute
   #:dt-hour
   #:dt-day
   #:dt-month
   #:dt-year
   #:datetime
   #:dt-time-zone
   #:make-datetime
   #:universal-time->datetime
   #:unix->datetime
   #:make-now-datetime
   #:dt-day-of-week
   #:dt->unix
   #:dt->ut
   #:dt-day-of-year
   #:dt=
   #:dt<
   #:dt<=
   #:dt>
   #:dt>=
   #:dt+
   #:dt-
   #:dt+/ts
   #:dt-/ts
   #:dt+seconds
   #:dt+minutes
   #:dt+hours
   #:dt+days
   #:dt+months
   #:dt+years

   ;; printing.lisp
   #:dt->string
   #:ts->string

   ;; parsing.lisp
   #:datetime-parse-error
   #:bad-day-of-week-error
   #:use-actual-value
   #:t/date-format
   #:parse-time)
  (:documentation "The :P36-LIB/TIME package provides ways to represent dates
  and times, spans of time, and functions to manipulate them."))
