;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/terminal
  (:use :common-lisp :cl-sdm)
  (:shadowing-import-from :cl :write-string)
  (:nicknames :sdm-term)
  (:documentation
   "ANSI terminal utilities")

  (:export
   #:t/cursor-ctrl/direction
   #:t/erase-in-display
   #:t/erase-in-line
   #:t/ansi-simple-color
   #:+ansi-color-map+
   #:ansi/format-bold
   #:ansi/format-colored
   #:ansi/with-color
   #:ansi/with-256-color
   #:colorize-string
   #:colorize-string-256
   #:bold-string
   #:ansi/format
   #:ansi/cursor-ctrl
   #:ansi/set-cursor-pos
   #:ansi/erase-in-display
   #:ansi/erase-in-line
   #:ansi/scroll
   #:ansi/aux-port-ctrl
   #:ansi/save-cursor-pos
   #:ansi/restore-cursor-pos
   #:ansi/hide-cursor
   #:ansi/show-cursor
   #:ansi/reset-terminal
   #:ansi/default-font
   #:ansi/set-alternate-font
   #:xterm/set-window-title
   #:terminology/show-media
   #:terminology/show-thumb
   #:terminology/query-grid
   #:terminology/set-alpha-state
   #:terminology/set-background
   #:terminology/popup

   #:get-terminal-size

   #:progress-bar-error
   #:progress-bar-done-error
   #:progress-bar-refresh
   #:progress-bar-done
   #:progress-bar-pump
   #:progress-bar-reset
   #:progress-bar-auto-refresh-p
   #:progress-bar-allow-over-100-p
   #:progress-bar-label
   #:progress-bar-label-width
   #:progress-bar-post-label
   #:progress-bar-post-label-width
   #:progress-bar-stream
   #:progress-bar-max
   #:progress-bar-step
   #:progress-bar
   #:progress-bar-done-p
   #:with-progress-bar
   ))
