;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-user)

(defpackage :cl-sdm-rsconf
  (:use #:common-lisp #:cl-sdm)
  (:nicknames :sdm-rsconf)
  (:shadowing-import-from #:common-lisp #:write-string)
  (:shadow #:read-string)
  (:export
   ;; common.lisp
   #:rsconf-error
   #:rsconf-encoding-error
   #:rsconf-bom-error
   #:t/object
   #:t/number
   #:t/bool
   #:t/null
   #:t/string
   #:t/array
   #:t/value

   ;; parser.lisp
   #:parse
   #:rsconf-parse-error
   #:error-line
   #:error-column

   ;; writer.lisp
   #:rsconf-writer
   #:rsconf-writer-indent-size
   #:rsconf-writer-always-quote-keys-p
   #:rsconf-writer-always-use-scientific-notation-p
   #:rsconf-writer-explicit-root-object-p
   #:rsconf-writer-comma-after-values-p
   #:rsconf-writer-extra-newline-between-toplevel-keys-p
   #:rsconf-write
   #:rsconf-write-to-string))
