;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm
  (:use :common-lisp)
  (:nicknames :sdm)
  (:shadow :write-string)
  (:export
   ;; arraypool.lisp
   #:array-pool-error
   #:array-pool-error-array
   #:array-pool
   #:array-pool-type
   #:array-pool-default-value
   #:make-array-pool
   #:array-pool-rent
   #:array-pool-return
   #:with-rented-array

   ;; binary-char-stream.lisp
   #:utf-8-byte-sequence-error
   #:binary-utf-8-input-stream
   #:binary-utf-8-output-stream
   #:binary-utf-8-input-stream-back-buffer-length
   #:binary-utf-8-input-stream-back-buffer-byte-length
   #:binary-utf-8-input-stream-do-read-char
   #:binary-utf-8-input-stream-do-read-line
   #:binary-utf-8-input-stream-do-unread-char
   #:binary-utf-8-input-stream-do-write-char

   ;; bit-reader.lisp
   #:not-on-byte-error
   #:bit-reader
   #:make-bit-reader
   #:bit-reader-rewind
   #:bit-reader-reinitialize
   #:bit-reader-read
   #:bit-reader-read-bytes
   #:bit-reader-read-bytes!
   #:bit-reader-read-string
   #:bit-reader-read-string!
   #:bit-reader-bit-pos
   #:bit-reader-cur-byte
   #:bit-reader-pos
   #:bit-reader-count-zeros
   #:bit-reader-count-ones
   #:bit-reader-peek
   #:bit-reader-peek-bytes
   #:bit-reader-advance-to-next-byte
   #:bit-reader-read-sequence
   #:bit-reader-read-int16
   #:bit-reader-read-int16/be
   #:bit-reader-read-int24
   #:bit-reader-read-int24/be
   #:bit-reader-read-int32
   #:bit-reader-read-int32/be
   #:bit-reader-read-int64
   #:bit-reader-read-int64/be
   #:bit-reader-read-uint16
   #:bit-reader-read-uint16/be
   #:bit-reader-read-uint24
   #:bit-reader-read-uint24/be
   #:bit-reader-read-uint32
   #:bit-reader-read-uint32/be
   #:bit-reader-read-uint64
   #:bit-reader-read-uint64/be
   #:bit-reader-close

   ;; common.lisp
   #:*io-buffer-size*
   #:gc
   #:exit
   #:xor
   #:with-gensyms
   #:hash-table-contains-p
   #:defconst
   #:defining-consts
   #:hash-let
   #:hash-try-add
   #:parse-integer?
   #:define-typed-fn
   #:binding-multiple-values
   #:with-typed-slots
   #:new-vector
   #:new-array
   #:new-array-with
   #:new-array-with-ctor
   #:dx-let
   #:find-program-in-path
   #:with-bound-slot
   #:if-slot-bound
   #:create-empty-file
   #:muffling
   #:define-simple-error
   #:when-var
   #:with-interrupts-disabled
   #:without-interrupts
   #:merge-pathnames-as-dir
   #:merge-paths
   #:vec-last
   #:vec-first

   ;; crc32.lisp
   #:crc32
   #:make-crc32
   #:crc32-reset
   #:crc32-crc
   #:crc32-update
   #:crc32-update-count
   #:with-crc32

   ;; crc64.lisp
   #:+crc64-ecma-polynomial+
   #:+crc64-iso-polynomial+
   #:crc64
   #:make-crc64
   #:crc64-reset
   #:crc64-crc
   #:crc64-polynomial
   #:crc64-update
   #:with-crc64

   ;; io.lisp
   #:with-stream-excursion
   #:bytes->string
   #:bytes->uint
   #:uint->bytes
   #:uint->byte-vector
   #:bytes->dfloat
   #:bytes->sfloat
   #:bytes->float
   #:float->bytes
   #:float->byte-vector
   #:sfloat->bytes
   #:dfloat->bytes
   #:sfloat->byte-vector
   #:dfloat->byte-vector
   #:string->bytes
   #:read-bytes
   #:read-string
   #:read-null-term-string
   #:if-read-string
   #:expect-string
   #:read-bytes-into-int
   #:write-bytes
   #:write-string
   #:write-uint
   #:write-uint8
   #:write-uint16
   #:write-uint24
   #:write-uint32
   #:write-uint64
   #:write-uint16/be
   #:write-uint24/be
   #:write-uint32/be
   #:write-uint64/be
   #:write-sfloat
   #:write-sfloat/be
   #:write-dfloat
   #:write-dfloat/be
   #:write-int8
   #:write-int16
   #:write-int24
   #:write-int32
   #:write-int64
   #:write-int16/be
   #:write-int24/be
   #:write-int32/be
   #:write-int64/be
   #:read-uint8
   #:read-uint16
   #:read-uint24
   #:read-uint32
   #:read-uint64
   #:read-uint16/be
   #:read-uint24/be
   #:read-uint32/be
   #:read-uint64/be
   #:read-sfloat
   #:read-sfloat/be
   #:read-dfloat
   #:read-dfloat/be
   #:read-int8
   #:read-int16
   #:read-int24
   #:read-int32
   #:read-int64
   #:read-int16/be
   #:read-int24/be
   #:read-int32/be
   #:read-int64/be

   ;; io-extra.lisp
   #:read-stream-to-end
   #:read-file-to-end
   #:copy-bytes
   #:read-line*

   ;; memory-stream.lisp
   #:t/memory-stream-buffer
   #:memory-stream-error
   #:memory-stream-read-only-error
   #:memory-stream-buffer
   #:memory-stream-buffer!
   #:memory-stream-string
   #:memory-stream-read-only-p
   #:memory-stream-size
   #:memory-stream-reset
   #:memory-stream-length
   #:memory-stream
   #:with-memory-stream

   ;; memory-utf-8-stream.lisp
   #:memory-utf-8-stream

   ;; numbers.lisp
   #:+half-pi+
   #:+quarter-pi+
   #:+two-pi+
   #:+four-pi+
   #:+positive-inf/sfloat+
   #:+positive-inf/dfloat+
   #:+negative-inf/sfloat+
   #:+negative-inf/dfloat+
   #:num-8bit-bytes-needed
   #:int->uint/2c
   #:uint->int/2c
   #:signed->unsigned
   #:coerce-to-int8
   #:coerce-to-int16
   #:coerce-to-int24
   #:coerce-to-int32
   #:coerce-to-int64
   #:coerce-to-uint8
   #:coerce-to-uint16
   #:coerce-to-uint24
   #:coerce-to-uint32
   #:coerce-to-uint64
   #:coerce-to-bit-size
   #:t/special-floats
   #:dfloat->uint64
   #:sfloat->uint32
   #+(or sbcl ccl) #:fast-sfloat->uint32
   #+(or sbcl ccl) #:fast-dfloat->uint64
   #+(or sbcl ccl) #:fast-uint32->sfloat
   #+(or sbcl ccl) #:fast-uint64->dfloat
   #:uint64->dfloat
   #:uint32->sfloat
   #:clamp
   #:clampf
   #:num-leading-zeros
   #:num-leading-ones
   #:swap-endianness
   #:flag?
   #:logxorf
   #:logiorf
   #:logandf
   #:logandc2f
   #:if-within
   #:if-within!
   #:when-within
   #:when-within!
   #:unless-within
   #:unless-within!
   #:fast-sin
   #:fast-cos
   #:fast-tan
   #:fast-inv-sin
   #:fast-inv-cos
   #:fast-inv-tan
   #:faster-sin
   #:faster-cos
   #:faster-tan
   #:faster-inv-sin
   #:faster-inv-cos
   #:faster-inv-tan
   #:fast-tanh
   #:fast-atan
   #:fast-sin/l
   #:fast-cos/l
   #:fast-tan/l
   #:fast-inv-sin/l
   #:fast-inv-cos/l
   #:fast-inv-tan/l
   #:faster-sin/l
   #:faster-cos/l
   #:faster-tan/l
   #:faster-inv-sin/l
   #:faster-inv-cos/l
   #:faster-inv-tan/l
   #:fast-tanh/l
   #:fast-atan/l
   #:fast-sin/s
   #:fast-cos/s
   #:fast-tan/s
   #:fast-inv-sin/s
   #:fast-inv-cos/s
   #:fast-inv-tan/s
   #:faster-sin/s
   #:faster-cos/s
   #:faster-tan/s
   #:faster-inv-sin/s
   #:faster-inv-cos/s
   #:faster-inv-tan/s
   #:fast-tanh/s
   #:fast-atanh/s
   #:fast-sin/r
   #:fast-cos/r
   #:fast-tan/r
   #:fast-inv-sin/r
   #:fast-inv-cos/r
   #:fast-inv-tan/r
   #:faster-sin/r
   #:faster-cos/r
   #:faster-tan/r
   #:faster-inv-sin/r
   #:faster-inv-cos/r
   #:faster-inv-tan/r
   #:fast-tanh/r
   #:fast-atan/r
   #:multiply-add
   #:multiply-add-2
   #:multiply-add-2/f
   #:multiply-add-2/l
   #:multiply-add-2/r
   #:multiply-add-2/s
   #:multiply-add-step
   #:multiply-add-step/f
   #:multiply-add-step/l
   #:multiply-add-step/r
   #:multiply-add-step/s
   #:multiply-add/f
   #:multiply-add/l
   #:multiply-add/r
   #:multiply-add/s

   ;; parse-float.lisp
   #:float-parse-error
   #:t/valid-radix
   #:parse-float

   ;; pseudo-enums.lisp
   #:define-pseudo-enum

   ;; sequences.lisp
   #:mapappend
   #:any?
   #:contains-any?
   #:shuffle-sequence-inplace
   #:shuffle-sequence
   #:sample
   #:fill-sequence
   #:doseq
   #:shift
   #:shift-list
   #:swap
   #:seq-last
   #:partition
   #:every-is-a-p

   ;; sized-stream.lisp
   #:sized-stream-closed-error
   #:t/sized-stream-max
   #:sized-stream
   #:sized-stream-sync-close-p
   #:sized-stream-closed-p
   #:sized-stream-read-remaining
   #:make-sized-stream

   ;; strings.lisp
   #:+ascii-whitespace+
   #:+basic-whitespace+
   #:+extra-whitespace+
   #:trim-whitespace
   #:strings+
   #:caseless-string=
   #:caseless-char=
   #:pretty-print-bytes
   #:split-string
   #:split-string*
   #:print-indented-string
   #:indent-string
   #:string-replace
   #:string-replace-with
   #:string-sanitize
   #:*string-sanitize*
   #:*string-sanitize-extra*
   #:string-starts-with
   #:string-ends-with
   #:string-case
   #:empty-string-p
   #:empty-string-p!
   #:char-in-range-p
   #:trim-whitespace!
   #:strings-join
   #:strings-join!
   #:strings-join-vector
   #:strings-join-vector!
   #:string-partition
   #:whitespace-char-p
   #:ascii-char-p
   #:ascii-control-char-p
   #:ascii-lower-case-char-p
   #:ascii-upper-case-char-p
   #:ascii-alpha-p
   #:ascii-alphanumeric-p
   #:char->utf-8

   ;; types.lisp
   #:t/ufixnum
   #:t/uint8
   #:t/uint16
   #:t/uint24
   #:t/uint32
   #:t/uint64
   #:t/uint128
   #:t/int8
   #:t/int16
   #:t/int24
   #:t/int32
   #:t/int64
   #:t/int128
   #:t/shfloat-vector
   #:t/shfloat-array
   #:t/sfloat-vector
   #:t/sfloat-array
   #:t/dfloat-vector
   #:t/dfloat-array
   #:t/lfloat-vector
   #:t/lfloat-array
   #:t/uint8-vector
   #:t/uint16-vector
   #:t/uint24-vector
   #:t/uint32-vector
   #:t/uint64-vector
   #:t/int8-vector
   #:t/int16-vector
   #:t/int24-vector
   #:t/int32-vector
   #:t/int64-vector
   #:t/uint8-array
   #:t/uint16-array
   #:t/uint24-array
   #:t/uint32-array
   #:t/uint64-array
   #:t/int8-array
   #:t/int16-array
   #:t/int24-array
   #:t/int32-array
   #:t/int64-array

   ;; version.lisp
   #:+cl-sdm-version+

   ;; z85.lisp
   #:z85-error
   #:z85-encode
   #:z85-decode))
