;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/mmapped-file
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-mmapped-file)
  (:shadowing-import-from :cl-sdm #:write-string)
  ;;(:shadow #:muffling)
  (:export
   ;;;
   ;;; mmapped-file.lisp
   ;;;

   #:mmapped-file-error
   #:mmapped-file-seek-error
   #:mmapped-file-eof-error
   #:t/mmapped-file-mode
   #:mmapped-file
   #:mmapped-file-size
   #:mmapped-file-cur-offset
   #:make-mmapped-file
   #:close-mmapped-file
   #:mmapped-file-open-p
   #:with-mmapped-file

   #:mmapped-file-read-byte
   #:mmapped-file-read-uint16
   #:mmapped-file-read-uint32
   #:mmapped-file-read-uint64
   #:mmapped-file-read-int8
   #:mmapped-file-read-int16
   #:mmapped-file-read-int32
   #:mmapped-file-read-int64
   #:mmapped-file-read-uint16/be
   #:mmapped-file-read-uint32/be
   #:mmapped-file-read-uint64/be
   #:mmapped-file-read-int16/be
   #:mmapped-file-read-int32/be
   #:mmapped-file-read-int64/be

   #:mmapped-file-get-byte
   #:mmapped-file-get-uint16
   #:mmapped-file-get-uint32
   #:mmapped-file-get-uint64
   #:mmapped-file-get-int8
   #:mmapped-file-get-int16
   #:mmapped-file-get-int32
   #:mmapped-file-get-int64
   #:mmapped-file-get-uint16/be
   #:mmapped-file-get-uint32/be
   #:mmapped-file-get-uint64/be
   #:mmapped-file-get-int16/be
   #:mmapped-file-get-int32/be
   #:mmapped-file-get-int64/be

   #:mmapped-file-read-float32
   #:mmapped-file-read-float64
   #:mmapped-file-get-float32
   #:mmapped-file-get-float64
   #:mmapped-file-read-float32/be
   #:mmapped-file-read-float64/be
   #:mmapped-file-get-float32/be
   #:mmapped-file-get-float64/be

   #:mmapped-file-read-string
   #:mmapped-file-get-string
   #:mmapped-file-read-bytes
   #:mmapped-file-get-bytes

   #:mmapped-file-write-byte
   #:mmapped-file-write-uint16
   #:mmapped-file-write-uint32
   #:mmapped-file-write-uint64
   #:mmapped-file-write-uint16/be
   #:mmapped-file-write-uint32/be
   #:mmapped-file-write-uint64/be
   #:mmapped-file-write-int8
   #:mmapped-file-write-int16
   #:mmapped-file-write-int32
   #:mmapped-file-write-int64
   #:mmapped-file-write-int16/be
   #:mmapped-file-write-int32/be
   #:mmapped-file-write-int64/be

   #:mmapped-file-put-byte
   #:mmapped-file-put-uint16
   #:mmapped-file-put-uint32
   #:mmapped-file-put-uint64
   #:mmapped-file-put-uint16/be
   #:mmapped-file-put-uint32/be
   #:mmapped-file-put-uint64/be
   #:mmapped-file-put-int8
   #:mmapped-file-put-int16
   #:mmapped-file-put-int32
   #:mmapped-file-put-int64
   #:mmapped-file-put-int16/be
   #:mmapped-file-put-int32/be
   #:mmapped-file-put-int64/be

   #:mmapped-file-write-float32
   #:mmapped-file-write-float64
   #:mmapped-file-put-float32
   #:mmapped-file-put-float64

   #:mmapped-file-write-string
   #:mmapped-file-put-string
   #:mmapped-file-write-bytes
   #:mmapped-file-put-bytes))

(defpackage :cl-sdm/mmapped-file-gray
  (:use :common-lisp :cl-sdm :cl-sdm/mmapped-file)
  (:nicknames :sdm-mmap-gray)
  (:shadowing-import-from :cl-sdm #:write-string)
  (:export

   ;;;
   ;;; gray.lisp
   ;;;

   #:mmapped-input-stream
   #:mmapped-output-stream
   #:mmapped-stream
   #:open-mmapped-stream
   #:with-mmapped-stream))
