;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm/logging)

(deftype t/log-priority ()
  '(member :fatal :error :warn :info :verbose :debug))

(deftype t/log-tag ()
  '(or keyword symbol string))

(defun muffle-list-p (thing)
  (declare (optimize (speed 3) (space 0) (debug 0)))
  (every #'(lambda (x)
             (typep x 't/log-tag))
         thing))

(deftype t/muffle-list ()
  '(and list
    (satisfies muffle-list-p)))

(define-condition logger-fatal-condition (cl:error)
  ((text
    :initarg :text
    :initform ""
    :accessor error-text)

   (code
    :initarg :code
    :initform 1
    :accessor error-code))
  (:report (lambda (err out)
             (with-slots (text code) err
               (if (empty-string-p text)
                   (format out "A condition of type LOGGER-FATAL-ERROR was signaled with code ~a" code)
                   (format out "~a" text))))))
