;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/logging
  (:use :common-lisp :cl-sdm)
  (:shadow
   :log
   :warn
   :error
   :muffling)
  (:nicknames :sdm-log)
  (:shadowing-import-from :cl :write-string)
  (:export
   ;;
   ;; logger.lisp
   ;;
   #:print-header
   #:build-message-string
   #:print-message
   #:logger
   #:logger-fatal-error-p
   #:logger-header/fatal
   #:logger-header/error
   #:logger-header/warn
   #:logger-header/log
   #:logger-header/verbose
   #:logger-header/debug
   #:logger-header-date-format
   #:logger-indent-headers-p
   #:logger-ensure-newline-p
   #:logger-fatal-stream
   #:logger-error-stream
   #:logger-warn-stream
   #:logger-log-stream
   #:logger-verbose-stream
   #:logger-debug-stream
   #:logger-muffle
   #:logger-show-empty-headers-p
   #:logger-show-tag-in-header-p
   #:logger-enabled-p
   #:logger-indent-size
   #:logger-indent-char
   #:logger-sanitize-p
   #:logger-synchronized-p
   #:logger-flush
   #:color-logger
   #:logger-header-color/fatal
   #:logger-header-color/error
   #:logger-header-color/warn
   #:logger-header-color/log
   #:logger-header-color/verbose
   #:logger-header-color/debug
   #:multi-logger
   #:logger-extra-streams
   #:multi-color-logger

   ;; logging.lisp
   #:*logger*
   #:as-wrapped
   #:do-log
   #:dlog
   #:dlog*
   #:dlog*!
   #:dlog*
   #:dlog!
   #:vlog
   #:vlog*
   #:vlog*!
   #:vlog*
   #:vlog!
   #:log
   #:log*
   #:log*!
   #:log*
   #:log!
   #:warn
   #:warn*
   #:warn*!
   #:warn*
   #:warn!
   #:error
   #:error*
   #:error*!
   #:error*
   #:error!
   #:fatal*$
   #:fatal$
   #:fatal*
   #:fatal
   #:indenting
   #:muffling

   ;; types.lisp
   #:t/log-priority
   #:t/log-tag
   #:muffle-list-p
   #:t/muffle-list
   #:logger-fatal-condition
   #:error-text
   #:error-code))
