;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;;;
;;;; Package Definition
;;;;

(defpackage :cl-sdm/ini
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-ini)
  (:shadowing-import-from :common-lisp #:write-string)
  (:documentation "INI parsing and generation.")
  (:export
   #:ini-error
   #:parse-ini
   #:write-ini
   #:t/ini
   #:t/parser-state
   #:t/on-duplicates
   #:ini-parser
   #:make-ini-parser))
