;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;; HJSON code based on hjson-go, Copyright (C) 2016, 2017 Christian Zangl
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-user)

(defpackage :cl-sdm-hjson
  (:use :common-lisp :cl-sdm)
  (:shadow :write-string)
  (:nicknames :sdm-hjson)
  (:documentation
   "The CL-SDM-HJSON package implements a HJSON parser and functions to (un)marshal the parsed data.")

  (:export
   ;; common.lisp
   #:hjson-error
   #:line-col-error
   #:error-line
   #:error-column
   #:marshal-error
   #:unmarshal-error
   #:encoding-error
   #:t/hjson-null

   ;; decode.lisp
   #:parse-hjson

   ;; encode.lisp
   #:write-hjson

   ;; hjson-class.lisp
   #:hjson-class
   #:hjson-class-non-strict-p
   #:hjson-class-translate-hyphens-p
   #:hjson-class-unknown-fields-to-slot
   #:hjson-class-non-strict-marshalling-p
   #:hjson-slot
   #:hjson-slot/effective
   #:slot-ignore-p
   #:slot-dont-emit-default-val-p
   #:slot-marshal-fn
   #:slot-unmarshal-fn
   #:slot-unmarshal-type
   #:unmarshal
   #:marshal))
