;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;; HJSON code based on hjson-go, Copyright (C) 2016, 2017 Christian Zangl
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm-hjson)

;;;;
;;;; Common Conditions and Classes
;;;;

(deftype t/hjson-false ()
  '(member :false))

(deftype t/hjson-true ()
  '(member :true))

(define-condition hjson-error (simple-error)
  ()
  (:documentation "The base condition class for CL-HJSON errors."))

(define-condition line-col-error (error)
  ((line
    :initarg :line
    :initform 1
    :reader error-line)

   (column
    :initarg :column
    :initform 0
    :reader error-column))
  (:documentation "Mixin class for conditions that need to report a line and column."))

(define-condition marshal-error (hjson-error)
  ()
  (:documentation "Represents an error that occurred during marshaling of data."))

(define-condition unmarshal-error (hjson-error)
  ()
  (:documentation "Represents an error that occurred during unmarshaling to a
CLOS class (whether it uses the HJSON-CLASS metaclass or not)."))

(defmacro unmarshal-error (msg &rest fmt-args)
  `(error 'unmarshal-error
          :format-control ,msg
          :format-arguments (quote ,fmt-args)))

(define-condition encoding-error (hjson-error)
  ()
  (:documentation "Represents an error that occurred during HJSON
  encoding."))

(defmacro encoder-error (msg &rest fmt-args)
  `(error 'encoding-error
          :format-control ,msg
          :format-arguments (list ,@fmt-args)))
