;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/fixed
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-fixed)
  (:shadowing-import-from :cl :write-string)
  (:export
   #:define-fixed-point

   #:q7.8
   #:make-q7.8
   #:+q7.8-frac-bits+
   #:+q7.8-frac-unit+
   #:+q7.8-zero+
   #:+q7.8-one+
   #:+q7.8-min+
   #:+q7.8-max+
   #:+q7.8-epsilon+
   #:+q7.8-epsilon-plus-1+
   #:+q7.8-epsilon-minus-1+
   #:make-q7.8-from-int
   #:make-q7.8-from-sfloat
   #:make-q7.8-from-dfloat
   #:q7.8->sfloat
   #:q7.8->dfloat
   #:q7.8-abs
   #:q7.8+
   #:q7.8-
   #:q7.8*
   #:q7.8/
   #:q7.8-ash
   #:q7.8=
   #:q7.8/=
   #:q7.8<
   #:q7.8>
   #:q7.8<=
   #:q7.8>=
   #:q7.8-min
   #:q7.8-max
   #:q7.8->int-floor
   #:q7.8->int-ceiling
   #:q7.8->string

   #:q16.16
   #:make-q16.16
   #:+q16.16-frac-bits+
   #:+q16.16-frac-unit+
   #:+q16.16-zero+
   #:+q16.16-one+
   #:+q16.16-min+
   #:+q16.16-max+
   #:+q16.16-epsilon+
   #:+q16.16-epsilon-plus-1+
   #:+q16.16-epsilon-minus-1+
   #:make-q16.16-from-int
   #:make-q16.16-from-sfloat
   #:make-q16.16-from-dfloat
   #:q16.16->sfloat
   #:q16.16->dfloat
   #:q16.16-abs
   #:q16.16+
   #:q16.16-
   #:q16.16*
   #:q16.16/
   #:q16.16-ash
   #:q16.16=
   #:q16.16/=
   #:q16.16<
   #:q16.16>
   #:q16.16<=
   #:q16.16>=
   #:q16.16-min
   #:q16.16-max
   #:q16.16->int-floor
   #:q16.16->int-ceiling
   #:q16.16->string

   #:q24.24
   #:make-q24.24
   #:+q24.24-frac-bits+
   #:+q24.24-frac-unit+
   #:+q24.24-zero+
   #:+q24.24-one+
   #:+q24.24-min+
   #:+q24.24-max+
   #:+q24.24-epsilon+
   #:+q24.24-epsilon-plus-1+
   #:+q24.24-epsilon-minus-1+
   #:make-q24.24-from-int
   #:make-q24.24-from-sfloat
   #:make-q24.24-from-dfloat
   #:q24.24->sfloat
   #:q24.24->dfloat
   #:q24.24-abs
   #:q24.24+
   #:q24.24-
   #:q24.24*
   #:q24.24/
   #:q24.24-ash
   #:q24.24=
   #:q24.24/=
   #:q24.24<
   #:q24.24>
   #:q24.24<=
   #:q24.24>=
   #:q24.24-min
   #:q24.24-max
   #:q24.24->int-floor
   #:q24.24->int-ceiling
   #:q24.24->string

   #:q31.31
   #:make-q31.31
   #:+q31.31-frac-bits+
   #:+q31.31-frac-unit+
   #:+q31.31-zero+
   #:+q31.31-one+
   #:+q31.31-min+
   #:+q31.31-max+
   #:+q31.31-epsilon+
   #:+q31.31-epsilon-plus-1+
   #:+q31.31-epsilon-minus-1+
   #:make-q31.31-from-int
   #:make-q31.31-from-sfloat
   #:make-q31.31-from-dfloat
   #:q31.31->sfloat
   #:q31.31->dfloat
   #:q31.31-abs
   #:q31.31+
   #:q31.31-
   #:q31.31*
   #:q31.31/
   #:q31.31-ash
   #:q31.31=
   #:q31.31/=
   #:q31.31<
   #:q31.31>
   #:q31.31<=
   #:q31.31>=
   #:q31.31-min
   #:q31.31-max
   #:q31.31->int-floor
   #:q31.31->int-ceiling
   #:q31.31->string

   #:q32.32
   #:make-q32.32
   #:+q32.32-frac-bits+
   #:+q32.32-frac-unit+
   #:+q32.32-zero+
   #:+q32.32-one+
   #:+q32.32-min+
   #:+q32.32-max+
   #:+q32.32-epsilon+
   #:+q32.32-epsilon-plus-1+
   #:+q32.32-epsilon-minus-1+
   #:make-q32.32-from-int
   #:make-q32.32-from-sfloat
   #:make-q32.32-from-dfloat
   #:q32.32->sfloat
   #:q32.32->dfloat
   #:q32.32-abs
   #:q32.32+
   #:q32.32-
   #:q32.32*
   #:q32.32/
   #:q32.32-ash
   #:q32.32=
   #:q32.32/=
   #:q32.32<
   #:q32.32>
   #:q32.32<=
   #:q32.32>=
   #:q32.32-min
   #:q32.32-max
   #:q32.32->int-floor
   #:q32.32->int-ceiling
   #:q32.32->string))
