;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/file
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-file)
  (:shadowing-import-from :cl :write-string)
  (:export
   #:file-is-directory-p
   #:file-exists-p
   #:file-exists/directory-p
   #:file-basename
   #:file-size
   #:file-last-modified
   #:file-mode
   #:file-path
   #:file-info
   #:file-symlink-p
   #:make-file-info
   #:unwilden-pathname
   #:file-filename
   #:file-pattern-error
   #:file-matches-p
   #:native-namestring
   #:native-pathname

   #:+mode/socket+
   #:+mode/symlink+
   #:+mode/regular+
   #:+mode/block+
   #:+mode/directory+
   #:+mode/char+
   #:+mode/fifo+
   #:+perm/suid+
   #:+perm/sgid+
   #:+perm/sticky+
   #:+perm/own-rwx+
   #:+perm/own-r+
   #:+perm/own-w+
   #:+perm/own-x+
   #:+perm/group-rwx+
   #:+perm/group-r+
   #:+perm/group-w+
   #:+perm/group-x+
   #:+perm/other-rwx+
   #:+perm/other-r+
   #:+perm/other-w+
   #:+perm/other-x+
   #:+mode/unknown+))
