;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm-crc
  (:use #:common-lisp #:cl-sdm)
  (:shadowing-import-from #:common-lisp #:write-string)
  (:nicknames :sdm-crc)
  (:export
   ;; crc32.lisp
   #:crc32
   #:make-crc32
   #:crc32-reset
   #:crc32-crc
   #:crc32-update
   #:crc32-update-count
   #:with-crc32

   ;; crc64.lisp
   #:+crc64-ecma-polynomial+
   #:+crc64-iso-polynomial+
   #:crc64
   #:make-crc64
   #:crc64-reset
   #:crc64-crc
   #:crc64-polynomial
   #:crc64-update
   #:with-crc64))
