;;;; CL-RemiConf
;;;; Copyright (C) 2022 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm-config-remimarshal)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (defclass yaml-format (sdm-conf::config-file
                         cl-remimarshal-yaml:yaml-unmarshallable)
    ())

  (defun %read-config-instance/yaml (filename type)
    (check-type filename pathname)
    (cl-remimarshal-yaml:unmarshal (read-file-to-end filename :return-type :string)
                                   type))


  (defun %write-config-instance/yaml (filename obj &key if-exists)
    (with-open-file (out filename :if-exists if-exists :if-does-not-exist :create
                                  :direction :output)
      (cl-remiyaml:emit (cl-remimarshal-yaml:marshal-yaml-data obj) out))))


(handler-bind
    ((error (lambda (err)
              (when (find-restart 'sdm-conf::overwrite err)
                (invoke-restart (find-restart 'sdm-conf::overwrite err))))))
  (sdm-conf::%register-support-format :yaml
                                      'yaml-format #'%read-config-instance/yaml #'%write-config-instance/yaml))
