;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-user)

(defpackage :cl-sdm-config
  (:use #:common-lisp #:cl-sdm)
  (:nicknames :sdm-conf)
  (:shadowing-import-from #:common-lisp #:write-string)
  (:export
   ;; resolver.lisp
   #:t/directory-type
   #:define-data-file
   #:resolver-get-data-file
   #:resolver-get-data-file!
   #:resolver-get-data-file-stream
   #:resolver-get-data-file-stream!
   #:unknown-data-file
   #:file-does-not-exist
   #:missing-data-file
   #:error-symbolic-name
   #:resolver
   #:resolver-type
   #:resolver-base-name
   #:resolver-data-dir
   #:resolver-config-dir
   #:make-resolver
   #:with-open-data-file
   #:resolver-p
   #:resolver-list-p

   ;; priority-resolver.lisp
   #:priority-resolver
   #:priority-resolver-resolvers
   #:priority-resolver-add
   #:priority-resolver-insert
   #:priority-resolver-remove
   #:make-priority-resolver

   ;; config-file.lisp
   #:get-known-support-formats
   #:get-support-format-class
   #:get-config-instance
   #:read-config-instance
   #:read-config-instance!
   #:write-config-instance
   #:read-or-make-config-instance
   #:config-filename))
