;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;; HJSON code based on hjson-go, Copyright (C) 2016, 2017 Christian Zangl
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-user)

(defpackage :cl-sdm-bzip2
  (:use :common-lisp :cl-sdm)
  (:shadow :write-string)
  (:nicknames :sdm-bzip2)
  (:documentation
   "Native BZip2 compression and decompression.")

  (:export
   ;; decompression.lisp
   #:bzip2-reader
   #:bzip2-reader-sync-close-p
   #:make-bzip2-reader
   #:with-bzip2-reader
   #:with-open-bzip2-reader
   ))
