;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;; Copyright (C) 2015 Jaime Olivares
;;;; Copyright (c) 2011 Matthew Francis
;;;; Ported from the Java implementation by Matthew Francis:
;;;; https://github.com/MateuszBartosiewicz/bzip2.
;;;;
;;;; Ported by Remilia Scarlet from the C# implementation by Jamie Olivares:
;;;; http://github.com/jaime-olivares/bzip2
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm-bzip2)

(defstruct (move-to-front (:constructor %make-move-to-front))
  (mtf (new-array 256 t/uint8) :type (simple-array t/uint8 (256))))

(defun make-move-to-front ()
  (%make-move-to-front
   :mtf (make-array 256 :element-type 't/uint8
                        :initial-contents (loop for i fixnum from 0 below 256 collect i))))

(define-typed-fn mtf-value-to-front ((move-to-front mtf) (t/uint8 value))
    (t/int32)
  (let* ((data (move-to-front-mtf mtf))
         (index 0)
         (tmp (aref data 0))
         (tmp2 0))
    (declare (type t/int32 index)
             (type t/uint8 tmp tmp2))

    (unless (= value tmp)
      (setf (aref data 0) value)
      (loop until (= value tmp) do
        (incf index)
        (setf tmp2 tmp)
        (setf tmp (aref data index))
        (setf (aref data index) tmp2)))
    index))

(define-typed-fn mtf-index-to-front ((move-to-front mtf) (t/int32 index))
    (t/uint8 t)
  (declare (optimize (speed 3) (debug 1) (safety 0) (compilation-speed 0)))
  (let* ((data (move-to-front-mtf mtf))
         (new-data (copy-seq data))
         (ret (aref data index)))
    (loop for i fixnum from 1
          for times fixnum from 0 below index do
            (setf (aref new-data i) (aref data (1- i))))
    (setf (aref new-data 0) ret)
    (setf (move-to-front-mtf mtf) new-data)
    ret))
