;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/clocks-lib
  (:use :common-lisp :cl-sdm :cffi)
  (:shadowing-import-from :cl :write-string)
  (:documentation "Clock support (low-level C bindings).")
  (:export
   #+unix :*errno*
   #+unix #:clock-gettime
   #+unix #:clock-getres
   #+unix #:time-t
   #+unix #:clockid-t
   #+unix #:timespec
   #+unix #:sec
   #+unix #:nsec
   #+unix #:clock-monotonic
   #+unix #:clock-realtime

   #+linux #:clock-realtime-coarse
   #+linux #:clock-monotonic-coarse
   #+linux #:clock-boottime
   #+linux #:clock-process-cputime-id
   #+linux #:clock-thread-cputime-id
   #+linux #:clock-monotonic-raw))

(defpackage :cl-sdm/clocks
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-clocks)
  (:shadowing-import-from :cl :write-string)
  (:documentation "Clock support.")

  (:export
   #:clock-now
   #:clock-now/ms
   #:clock-time-units-per-second
   #:clock-resolution))
