;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm/clocks-lib)

;;;;
;;;; Clocks Grovel File for Linux.  A kernel of at least v2.6.39 is required.
;;;;
;;;; Originally from monotonic-clock by death.
;;;;

(include "time.h")

(ctype time-t "time_t")
(ctype clockid-t "clockid_t")

;; POSIX clocks.
(constant (clock-monotonic "CLOCK_MONOTONIC"))
(constant (clock-realtime "CLOCK_REALTIME"))

;; Linux-specific clocks.
#+linux (constant (clock-realtime-coarse "CLOCK_REALTIME_COARSE"))
#+linux (constant (clock-monotonic-coarse "CLOCK_MONOTONIC_COARSE"))
#+linux (constant (clock-boottime "CLOCK_BOOTTIME"))
#+linux (constant (clock-process-cputime-id "CLOCK_PROCESS_CPUTIME_ID"))
#+linux (constant (clock-thread-cputime-id "CLOCK_THREAD_CPUTIME_ID"))
#+linux (constant (clock-monotonic-raw "CLOCK_MONOTONIC_RAW"))
