;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm/clocks-lib)

;;;;
;;;; Clock FFI for Unix
;;;;
;;;; Originally from monotonic-clock by death, expanded upon by Remilia Scarlet.
;;;;

(defcvar "errno" :int)

(defcstruct timespec
  (sec time-t)
  (nsec :long))

(defcfun clock-gettime :int
  (clockid clockid-t)
  (tp (:pointer (:struct timespec))))

(defcfun clock-getres :int
  (clockid clockid-t)
  (res (:pointer (:struct timespec))))
