;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
(in-package :cl-sdm/clocks)

;;;;
;;;; Clocks - Other systems
;;;;
;;;; These basically all throw errors.
;;;;

(define-typed-fn clock-time-units-per-second ((t/mode mode))
    (t/uint32 t)
  "Return the number of time units in one second for the given mode."
  (clock-error () "CLOCK-NOW is not supported on this system."))

(defun clock-now (&optional (mode :default))
  "Returns the current time in clock time units.  MODE must be a T/MODE.  The
default is to return a monotonic time."
  (clock-error () "CLOCK-NOW is not supported on this system."))

(defun clock-now/ms (&optional (mode :default))
  "Return the current time in milliseconds.  MODE must be a T/MODE.  The default is
to return a monotonic time."
  (clock-error () "CLOCk-NOW/MS is not supported on this system."))

(defun clock-resolution (&optional (mode :default))
  "Returns the precision of the specified T/MODE.  The first value is the seconds,
the second value is the nanoseconds."
  (clock-error () "CLOCK-RESOLUTION is not supported on this system."))
