;;;; CL-SDM - Opinionated Extra Batteries for Common Lisp
;;;; Copyright (C) 2021-2025 Remilia Scarlet <remilia@posteo.jp>
;;;;
;;;; This program is free software: you can redistribute it and/or modify it
;;;; under the terms of the GNU Affero General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or (at your
;;;; option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful, but WITHOUT
;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
;;;; License for more details.
;;;;
;;;; You should have received a copy of the GNU Affero General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

(defpackage :cl-sdm/argparser
  (:use :common-lisp :cl-sdm)
  (:nicknames :sdm-args)
  (:shadowing-import-from :cl :write-string)
  (:export
   ;; cmd-parser.lisp
   #:+default-help-command+
   #:+default-version-command+
   #:cmd-parser-get
   #:cmd-parser-get-data
   #:cmd-parser-add
   #:cmd-parser-add!
   #:cmd-parser-delete
   #:cmd-parser-get-help
   #:cmd-parser-commands
   #:parse-command
   #:cmd-parser
   #:cmd-parser-case-insensitive-p
   #:cmd-parser-help-printer
   #:cmd-parser-version-printer
   #:cmd-parser-program-name
   #:cmd-parser-program-fancy-name
   #:cmd-parser-program-version
   #:cmd-parser-help-pre-text
   #:cmd-parser-help-post-text
   #:cmd-parser-version-post-text
   #:cmd-parser-usage-string

   ;; common.lisp
   #:+default-help-short-name+
   #:+default-help-long-name+
   #:+default-version-short-name+
   #:+default-version-long-name+
   #:t/argument-type
   #:argument-error
   #:command-error
   #:no-command-error
   #:unknown-command-error
   #:duplicate-command-error
   #:argdef-error
   #:get-implementation-args
   #:default-help-printer
   #:default-version-printer
   #:parse-arguments
   #:error-text

   ;; argument-class.lisp
   #:argument
   #:arg-name
   #:arg-short-name
   #:arg-type
   #:arg-help
   #:arg-init-value
   #:arg-value
   #:arg-group
   #:arg-checking-fn
   #:arg-not-found-str
   #:arg-constraint

   ;; parser-class.lisp
   #:base-parser
   #:parser-allow-dash-dash-p
   #:parser-arguments-used-p
   #:parser-positional-args
   #:parser
   #:parser-program-name
   #:parser-program-fancy-name
   #:parser-program-version
   #:parser-help-pre-text
   #:parser-help-post-text
   #:parser-version-post-text
   #:parser-usage-string
   #:parser-help-short-arg
   #:parser-help-long-arg
   #:parser-version-short-arg
   #:parser-version-long-arg
   #:parser-help-printer
   #:parser-version-printer
   #:make-parser
   #:defargument
   #:get-arg-value
   #:arg-called-p
   #:get-integer-arg
   #:with-called-arg
   #:let-args
   #:let-args*
   #:if-arg
   #:parser-set-arg-value
   #:arg-called-as
   #:parser-reset
   #:parser-get-argument-groups

   ;; parsing.lisp
   #:with-args))
