;;;; rsconf-mode.el --- Major mode for editing RSConf files.            -*- lexical-binding: t; -*-
;;;;
;;;; This file is NOT part of GNU Emacs.
;;;;
;;;; Author: Remilia Scarlet
;;;;
;;;; License: AGPLv3

(defvar rsconf-mode-syntax-table nil "Syntax table for `rsconf-mode'.")

(setq rsconf-mode-syntax-table
      (let ((table (make-syntax-table)))
        (modify-syntax-entry ?\; "<" table)
        (modify-syntax-entry ?\n ">" table)
        (modify-syntax-entry ?\{ "(}" table)
        (modify-syntax-entry ?\} "){" table)
        table))

(setq rsconf-mode-highlights
      '(
        ;; make sure there is no colons preceeding it to fix
        ;; https://github.com/hjson/hjson/issues/112
        ;; any amount of keylike characters that don't start with "
        ;; \\(?:[^][(){},\s]\\)+
        ;; " then any non string ending character then "
        ;; It also allows escaping a double quote by /"
        ;; \"\\(?:[^\"\\]\\|\\\\.\\)*\"
        ;; whitespace before colon
        ;; \s*:
        ;; the whole thing other than the colon is wrapped in a group so
        ;; it doesn't colour the colon
        ;; keys
        ("^[^:]*?\\(\\(?:\\(?:[^][(){}:,\s]\\)+\\|\"\\(?:[^\"\\]\\|\\\\.\\)*\"\\)\s*\\):" . (1 font-lock-variable-name-face))

        ;; for key: "values" strings
        ("\"\\(?:[^\"\\\n]\\|\\\\.\\)*\"" . 'font-lock-string-face)

        ("true\\|false\\|null" . 'font-lock-constant-face)

        ;; numbers
        ("-?\\(0\\|[1-9][0-9]*\\)\\(\\(\\.[0-9]+\\)?\\([eE][+-]?[0-9]+\\)?\\)?" . 'font-lock-constant-face)

        ;; for *key: values* strings
        ("[:[]\s*\\([^\"\n]*$\\)" . (1 font-lock-string-face))))


;;;###autoload
(define-derived-mode rsconf-mode fundamental-mode "rsconf"
  "Major mode for editing RSConf files."
  (setq-local comment-start "# ")
  (setq-local comment-end "")
  (setq font-lock-defaults '(rsconf-mode-highlights nil nil)))

;; add the mode to the `features' list
(provide 'rsconf-mode)

(add-to-list 'auto-mode-alist '("\\.\\(rsconf\\|rsc\\)\\'" . rsconf-mode))

;;;; rsconf-mode.el ends here
