(require 'asdf)
(in-package :asdf-user)

(asdf:defsystem cl-sdm
  :class :sdm-system
  :long-name "CL-SDM"
  :description "Opinionated Extra Batteries for Common Lisp"
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm-semver
               #:babel
               #+(and sbcl unix) #:sb-posix
               #+sbcl #:sb-cltl2
               #:trivial-indent
               #:trivial-gray-streams
               #:uiop)

  :in-order-to
  ((test-op
    (test-op "cl-sdm-tests")))

  :components
  ((:module
    "src"
    :components
    ((:file "package")
     (:file "types" :depends-on ("package"))
     (:file "common" :depends-on ("package"))
     (:file "version" :depends-on ("package"))
     (:file "pseudo-enums" :depends-on ("package"))
     (:file "parse-float" :depends-on ("common"))
     (:file "numbers" :depends-on ("package") :around-compile apply-block-compilation)
     (:file "float-enc" :depends-on ("numbers") :around-compile apply-block-compilation)
     (:file "fast-float-enc-sbcl" :if-feature :sbcl :depends-on ("numbers") :around-compile apply-block-compilation)
     (:file "fast-float-enc-ccl" :if-feature :ccl :depends-on ("numbers"))
     (:file "sequences" :depends-on ("package") :around-compile apply-block-compilation)
     (:file "strings" :depends-on ("package") :around-compile apply-block-compilation)
     (:file "io" :depends-on ("strings" "numbers") :around-compile apply-block-compilation)
     (:file "bit-reader" :depends-on ("common") :around-compile apply-block-compilation)
     (:file "arraypool" :depends-on ("common") :around-compile apply-block-compilation)
     (:file "memory-stream" :depends-on ("io"))
     (:file "memory-utf-8-stream" :depends-on ("io"))
     (:file "io-extra" :depends-on ("io" "memory-stream") :around-compile apply-block-compilation)
     (:file "binary-char-stream" :depends-on ("io") :around-compile apply-block-compilation)
     (:file "sized-stream" :depends-on ("binary-char-stream") :around-compile apply-block-compilation)
     (:file "z85" :depends-on ("numbers") :around-compile apply-block-compilation)

     (:module
      "files" :depends-on ("common")
      :components
      ((:file "package")
       (:file "files" :depends-on ("package") :around-compile apply-block-compilation)
       (:file "globbing" :depends-on ("package") :around-compile apply-block-compilation)))

     (:module
      "time" :depends-on ("common")
      :components
      ((:file "package")
       (:file "functions" :depends-on ("package"))
       (:file "timespan" :depends-on ("functions"))
       (:file "datetime" :depends-on ("timespan"))
       (:file "parsing" :depends-on ("timespan" "datetime") :around-compile apply-block-compilation)
       (:file "printing" :depends-on ("timespan" "datetime" "functions") :around-compile apply-block-compilation)))

     (:module
      "terminal" :depends-on ("common")
      :components
      ((:file "package")
       (:file "ansi" :depends-on ("package") :around-compile apply-block-compilation)

       #+(and unix sbcl) (:file "ansi-terminology-unix" :depends-on ("package" "ansi"))
       #-(and unix sbcl) (:file "ansi-terminology-other" :depends-on ("package" "ansi"))

       (:file "ansi-terminology" :depends-on ("package" "ansi") :around-compile apply-block-compilation)

       #+sbcl (:file "terminal" :pathname "terminal-sbcl" :depends-on ("package"))
       #-sbcl (:file "terminal" :pathname "terminal-other" :depends-on ("package"))
       (:file "progress-bar" :depends-on ("ansi" "terminal"))))

     (:module
      "logging" :depends-on ("common" "terminal" "time")
      :components
      ((:file "package")
       (:file "types" :depends-on ("package"))
       (:file "logger" :depends-on ("types"))
       (:file "core" :depends-on ("logger"))
       (:file "logging" :depends-on ("core"))))

     (:module
      "shlog"
      :components
      ((:file "package")
       (:file "shlog" :depends-on ("package"))))

     (:module
      "argparser" :depends-on ("common" "parse-float")
      :components
      ((:file "package")
       (:file "common" :depends-on ("package"))
       (:file "argument-class" :depends-on ("common") :around-compile apply-block-compilation)
       (:file "parser-class" :depends-on ("argument-class") :around-compile apply-block-compilation)
       (:file "parsing" :depends-on ("parser-class") :around-compile apply-block-compilation)
       (:file "cmd-parser" :depends-on ("common") :around-compile apply-block-compilation)))))))
