(require 'asdf)
(in-package :asdf-user)

#-(or sbcl ccl clisp) (error "This Common Lisp implementation is not supported.")

(asdf:defsystem cl-sdm-uds
  :class :sdm-system
  :long-name "CL-SDM-UDS"
  :description "A simple wrapper library to provide access to local domain sockets (aka, UNIX domain sockets).  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm
               (:feature :sbcl #:sb-bsd-sockets)
               #:trivial-gray-streams)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "uds"
      :components
      ((:file "package")
       (:file "api")
       (:file "socket")
       (:file "backend/sbcl" :if-feature :sbcl)
       (:file "backend/ccl" :if-feature :ccl)
       (:file "backend/clisp" :if-feature :clisp)
       (:file "common-fn")
       (:file "grey")))))))
