;;;;
;;;; System Definition
;;;;

(require 'asdf)
(in-package :asdf-user)

(asdf:defsystem cl-sdm-tests
  :maintainer "Remilia Scarlet"
  :author "Remilia Scarlet"
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :depends-on (#:cl-sdm
               #:cl-sdm-semver
               (:feature (:not :clisp) #:cl-sdm-crc)
               #:cl-sdm-rsconf
               #:flexi-streams
               #:fiveam
               (:feature (:not :clisp) #:cl-sdm-ini))

  :serial t
  :components
  ((:module
    "t"
    :components
    ((:file "package")
     (:file "test-common")
     (:file "test-numbers")
     (:file "test-sequences")
     (:file "test-strings")
     (:file "test-io")
     (:file "test-bit-stream")
     (:file "test-crc64" :if-feature (:not :clisp))
     (:file "test-argparser")
     (:file "test-semver")
     (:file "test-array-pool")
     (:file "test-file")
     (:file "test-ini-parser" :if-feature (:not :clisp))
     (:file "test-rsconf")
     (:file "test-binary-utf-8-stream")
     (:file "test-memory-stream")
     (:file "test-memory-utf-8-stream")
     (:file "test-sized-stream"))))

  :perform (test-op (o s)
             (uiop:symbol-call :cl-sdm-tests
                               :run!
                               (find-symbol "CL-SDM-TEST-SUITE" :cl-sdm-tests))))

;;;; EOF ;;;;
