(require 'asdf)
(in-package :asdf-user)

#+(and sbcl (not sb-unicode)) (error "CL-SDM-RSCONF requires Unicode support")
#+(and ccl (not openmcl-unicode-strings)) (error "CL-SDM-RSCONF requires Unicode support")
#+(and clisp (not unicode)) (error "CL-SDM-RSCONF requires Unicode support")
#+(and ecl (not unicode)) (error "CL-SDM-RSCONF requires Unicode support")

(asdf:defsystem cl-sdm-rsconf
  :class :sdm-system
  :long-name "CL-SDM-RSCONF"
  :description "RSConf parser and writer.  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "rsconf"
      :components
      ((:file "package")
       (:file "common")
       (:file "parser" :around-compile apply-block-compilation)
       (:file "writer" :around-compile apply-block-compilation)))))))
