(require 'asdf)
(in-package :asdf-user)

#+clisp (error "Clisp is not supported.")

(asdf:defsystem cl-sdm-mmapped-file
  :class :sdm-system
  :long-name "CL-SDM-Mmapped-File"
  :description "Wrapper interface to read and write files using mmap().  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm
               #:trivial-gray-streams
               #:cffi
               #:mmap)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "mmapped-file"
      :components
      ((:file "package")
       (:file "mmapped-file" :around-compile apply-block-compilation)
       (:file "grey" :around-compile apply-block-compilation)))))))
