(require 'asdf)
(in-package :asdf-user)

#+clisp (error "Clisp is not supported.")

(asdf:defsystem cl-sdm-log-concurrent
  :class :sdm-system
  :long-name "CL-SDM Concurrent Logger"
  :description "Concurrent Logger for CL-SDM"
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm
               #:lparallel)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "logging"
      :components
      ((:module
        "concurrent"
        :components
        ((:file "concurrent-logger")))))))))
