(require 'asdf)
(in-package :asdf-user)

(asdf:defsystem cl-sdm-hjson
  :class :sdm-system
  :long-name "CL-SDM-HJSON"
  :description "HJSON parser, based on hjson-go by Christian Zangl.  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm
               #:closer-mop)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "hjson"
      :components
      ((:file "package")
       (:file "common")
       (:file "parse-number")
       (:file "decode")
       (:file "hjson-class")
       (:file "encode")))))))
