(require 'asdf)
(in-package :asdf-user)

(asdf:defsystem cl-sdm-fixed
  :class :sdm-system
  :long-name "CL-SDM fixed point support"
  :description "Provides arbitrary-sized fixed point support.  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "fixed"
      :components
      ((:file "package")
       (:file "fixed" :around-compile apply-block-compilation)))))))
