(require 'asdf)
(in-package :asdf-user)

#+clisp (error "Clisp is not supported.")

(asdf:defsystem cl-sdm-crc
  :class :sdm-system
  :long-name "CL-SDM-CRC"
  :description "CRC32 and CRC64 implementations."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "crc"
      :components
      ((:file "package")
       (:file "crc32" :around-compile apply-block-compilation)
       (:file "crc64" :around-compile apply-block-compilation)))))))
