(require 'asdf)
(in-package :asdf-user)

(asdf:defsystem cl-sdm-config
  :class :sdm-system
  :long-name "CL-SDM-CONFIG"
  :description "Abstract configuration file/directory management.  Part of
CL-SDM.  You probably want to :DEPENDS-ON either CL-SDM-CONFIG-REMIMARSHAL or
CL-SDM-CONFIG-HJSON instead."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm
               #:uiop
               #:closer-mop)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "config"
      :components
      ((:file "package")
       (:file "resolver")
       (:file "priority-resolver")
       (:file "config-file")))))))
