(require 'asdf)
(in-package :asdf-user)

(asdf:defsystem cl-sdm-config-remimarshal
  :class :sdm-system
  :long-name "CL-SDM-CONFIG-REMIMARSHAL"
  :description "CL-RemiMarshal support for CL-SDM-CONFIG (e.g. JSON and YAML).  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm-config
               (:version #:cl-remimarshal "0.4.2")
               #:cl-remimarshal-rsconf)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "config"
      :components
      ((:module
        "remimarshal"
        :components
        ((:file "package")
         (:file "json-format")
         (:file "yaml-format")
         (:file "rsconf-format")))))))))
