(require 'asdf)
(in-package :asdf-user)

(asdf:defsystem cl-sdm-clocks
  :class :sdm-system
  :long-name "CL-SDM-CLOCKS"
  :description "Clock support (e.g. clock_gettime equivalent on POSIX).  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf
                         #:cffi-grovel)
  :depends-on (#:cl-sdm
               #:cffi)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "clocks"
      :components
      ((:file "package")
       (:file "common")

       ;; Unix support
       (:cffi-grovel-file "grovel-unix" :if-feature :unix)
       (:file "ffi-unix" :if-feature :unix)
       (:file "clocks-unix" :if-feature :unix :around-compile apply-block-compilation)

       ;; For systems that aren't supported.
       (:file "clocks-others" :if-feature (:not (:or :unix)))))))))
