(require 'asdf)
(in-package :asdf-user)

#+clisp (error "Clisp is not supported.")

(asdf:defsystem cl-sdm-bzip2
  :class :sdm-system
  :long-name "CL-SDM-BZIP2"
  :description "Native BZip2 compression and decompression.  Part of CL-SDM."
  :version #.(nth 1 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :semantic-version #.(nth 0 (uiop:read-file-lines (uiop:subpathname *load-pathname* "version.txt")))
  :licence "GNU Affero General Public License Version 3 or Later"

  :maintainer "Remilia Scarlet <remilia@posteo.jp>"
  :author "Remilia Scarlet <remilia@posteo.jp>"
  :homepage "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/"
  :source-control (:fossil "https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/")

  :defsystem-depends-on (#:cl-sdm-asdf)
  :depends-on (#:cl-sdm
               #:cl-sdm-crc
               #:trivial-gray-streams)

  :serial t
  :components
  ((:module
    "src"
    :components
    ((:module
      "compression"
      :components
      ((:module
        "bzip2"
        :components
        ((:file "package")
         (:file "common")
         (:file "move-to-front" :around-compile apply-block-compilation)
         (:file "huffman-stage-decoder" :around-compile apply-block-compilation)
         (:file "block-decompressor" :around-compile apply-block-compilation)
         (:file "decompression" :around-compile apply-block-compilation)
         (:file "divsufsort") ;; :around-compile apply-block-compilation)
         (:file "bzip2-crc32" :around-compile apply-block-compilation)
         (:file "bit-writer" :around-compile apply-block-compilation)
         (:file "mtf-and-rle-2-stage-encoder")
         (:file "huffman-allocator" :around-compile apply-block-compilation)
         (:file "huffman-stage-encoder" :around-compile apply-block-compilation)
         (:file "block-compressor" :around-compile apply-block-compilation)
         (:file "writer" :around-compile apply-block-compilation)))))))))
