# CL-SDM

CL-SDM is a library that provides utility functions and some extra batteries to
Common Lisp.  It is, essentially, my personal standard library of things I tend
to use often.  CL-SDM supports SBCL primarily and is tested regularly with it.
ClozureCL and Clisp are also supported, and CL-SDM is tested semi-regularly with
these.  ECL seems to works, but it has some strange quirks, and is rarely
tested.

The main CL-SDM system is divided into a few separate sub-packages:

* **:sdm**: The core library functions.
* **:sdm-args**: Command line argument parser.
* **:sdm-file**: File information and pathname manipulation.
* **:sdm-log**: Logging facility.
* **:sdm-term**: ANSI terminal handling.
* **:sdm-time**: Date/Time Handling.

Most of the code was either designed out of need, but also occasionally to
reduce typing.  The library draws inspiration from Alexandria, UIOP, and the
standard library in Crystal (and Ruby, by extension), and in some cases
overlaps.

There are also some additional ASDF systems that ship with CL-SDM that are
designed to work with the main CL-SDM system:

* **:cl-sdm-asdf**: Defines some common ASDF stuff, such as the
  `APPLY-BLOCK-COMPILATION` function.
* **:cl-sdm-log-concurrent**: A concurrent version of `:sdm-log`.
* **:cl-sdm-mmapped-file**: A Grey Streams interface over `mmap()` that lets you
  read/write mmapped files like a stream.
* **:cl-sdm-uds**: Provides a Unix Domain Sockets API.
* **:sdm-rsconf**: [RSConf](https://chiselapp.com/user/MistressRemilia/repository/cl-sdm/file?name=docs/rsconf.md&ci=tip) parsing and emitting.
* **:sdm-hjson**: HJSON parsing and emitting (DEPRECATED, will be removed by
  v1.0).
* **:sdm-config**: Abstract configuration file/data directory management.
* **:sdm-config-remimarshal**: CL-RemiMarshal support for `:SDM-CONFIG`.
* **:sdm-config-hjson**: HJSON support for `:SDM-CONFIG` (DEPRECATED, will be
  removed by v1.0).
* **:sdm-semver**: Semantic Version parsing and comparisons.
* **:sdm-clocks**: Clock handling (like `clock_gettime()` in C).

Wanna support this project? [Buy Remilia a coffee on
Ko-Fi](https://ko-fi.com/L4L614QNC), or support Remilia's through Liberapay.

<a href='https://ko-fi.com/L4L614QNC' target='_blank'><img height='36' style='border:0px;height:36px;' src='https://cdn.ko-fi.com/cdn/kofi2.png?v=3' border='0' alt='Buy Me a Coffee at ko-fi.com' /></a>
<a href="https://liberapay.com/RemiliaScarlet/donate"><img alt="Donate using Liberapay" src="https://liberapay.com/assets/widgets/donate.svg"></a>

### How do I get set up?

There are two external dependencies: BABEL and TRIVIAL-INDENT.  Once you have these installed...

1. Clone this repository locally.
2. Use ASDF to load the system inside of your Lisp implementation (e.g., `(asdf:load-system :cl-sdm)`).
3. Enjoy.

## Development

### Style info

I use a slightly different style for my code.

- Keep lines 118 characters or shorter.  Obviously sometimes you can't, but please try.  Use 115 characters for
  Markdown files, though.
- New type declarations should have their names prefixed with `T/`, for example, `t/uint32-vector`.  This is only
  for DEFTYPEs and DEFINE-PSEUDO-ENUMs.
- Try not to go below `(DEBUG 1)` when optimizing unless it's an internal function that's been tested and is known
  to work well.  Slime has issues showing signatures when `(DEBUG 0)` is used.

### Unit Tests

The unit tests require two additional external dependencies: FLEXI-STREAMS and FiveAM.  Once these are installed,
just do `(asdf:test-system :cl-sdm)` from the REPL.

### TODO/Wishlist

This is partially just so I have a place to remember what I'm planning to do,
and a record of what I've done.  It is definitely not exhaustive or complete.

* __Core__
    - [x] XOR logic function.
    - [x] Nicer constant declarations.
    - [x] PARSE-INTEGER? that returns NIL instead of raising a condition when it can't parse.
    - [x] Float parsing
    - [x] Shorter type names for the common (un)signed integer types
    - [x] Shorter array/vector declarations
    - [x] Various macros to aid in making code more type safe.
    - [x] Pseudo-enums
    - [x] DEFINE-TYPED-FN ported from my CL-MeltySynth program and expanded
    - [/] Support for &key, &optional, and &rest in DEFINE-TYPED-FN
    - [x] Conversion to/from (un)signed integers
    - [x] CLAMP macro
    - [x] MAPAPPEND function
    - [x] Various nice functions inspired by Crystal/Ruby for inspecting sequences.
    - [x] SAMPLE function
    - [x] Sequence shuffling
    - [x] SHIFT functions
    - [x] Generic DOSEQ macro
    - [x] Equivalent of LAST for any sequence type.
    - [x] SWAP function
    - [x] Easier string trimming
    - [x] Caseless string comparisons
    - [x] CASE-like statement for strings
    - [x] Easier concatenation of things to a string
    - [x] Print numbers as binary sizes (KiB, MiB, etc).
    - [x] String spitting
    - [x] Pretty string indenting
    - [x] STRING-REPLACE
    - [x] STRING-STARTS-WITH and -ENDS-WITH
    - [x] JOIN function for strings
    - [x] Array pools
    - [x] Bit reader
    - [x] CRC64 digest
* __Argument Parsing__
    - [x] Support short (`-s`) and long (`--long`) arguments.
    - [x] Automatic --help and --version handling
    - [x] Custom help/version printing
    - [x] Positional arg support
    - [x] Fast parsing of arguments
    - [x] Call arbitrary functions to check argument values
    - [x] String arguments
    - [x] Flag arguments
    - [x] File arguments (like strings, but with some special handling)
    - [x] Numeric arguments
    - [x] Make positional arg support optional
    - [x] Optionally -- as an argument to indicate all remaining arguments are
          positional
* __I/O__
    - [x] Fast I/O functions for reading/writing integers in binary.
    - [x] Fast I/O functions for reading/writing floats in binary.
    - [x] Fast I/O functions for reading/writing strings in binary.
    - [x] Conversion of strings to/from sequences of bytes.
    - [x] Conversion of integers to/from sequences of bytes.
    - [x] Conversion of floats to/from sequences of bytes.
    - [x] 24-bit integer support in the I/O functions
    - [x] Mixin classes that allow reading and writing UTF-8 character data from
          binary streams.
    - [x] In-memory binary input/output stream that conforms to the Gray Streams
          interface.  Supports character UTF-8 I/O as well despite being binary.
    - [x] Size-limited streams.  Supports character UTF-8 input as well despite
          being binary.
* __Date/Time__
    - [x] Date/Time arithmetic
    - [x] Time Spans
    - [ ] Support fractional seconds
    - [x] Time Span -> String conversions
    - [x] Date Time -> String conversions
* __Terminal Handling__
    - [x] Basic ANSI support for colors and cursor control
    - [x] Progress bar
    - [x] Support for the Terminology terminal
    - [ ] Windows support (NOT PLANNED)
* __Files/Pathnames__
    - [x] Basename
    - [x] Check for existing directory
    - [x] Get file size
    - [x] Check if a path points to a directory or not
    - [x] Get some basic info (last modified, mode, etc.)
* __Logging__
    - [x] Tag-based logging, where tags can be muffled.
    - [x] Basic logger
    - [x] Logger with colored output
    - [x] Multi-logger (write to a logger once, and the strings go to 1+ destinations)
    - [x] Concurrent logger
* __RSConf__
    - [x] Full RSConf support (this is the reference implementation).
    - [x] RSConf parser.
    - [x] RSConf writer.

## How do I contribute?

1. Go to https://chiselapp.com/user/MistressRemilia/repository/cl-sdm and clone the Fossil repository.
2. Create a new branch for your feature.
3. Push locally to the new branch.
4. Create a [bundle](https://fossil-scm.org/home/help?cmd=bundle) with Fossil that contains your changes.
5. Get in contact with me.

## Contributors

* Remilia Scarlet - creator and maintainer
  * Homepage: [https://remilia.sdf.org/](https://remilia.sdf.org/)
  * Fediverse: [@remilia@social.cyberia9.org](https://social.cyberia9.org/@remilia)
  * Email: zremiliaz@postzeoz.jpz  My real address does not contain Z's
