# Benben Code of Conduct

The Benben project aims to be **enjoyable** for anyone to participate in,
regardless of their identity or level of expertise. To achieve this, the
community must create an environment which is **safe** and **equitable**; the
following guidelines have been created with these goals in mind.

1. **This is not a professional space.** Individuality is not only welcome, but
   encouraged. Professionalism asks marginalized individuals to censor
   themselves, and perform their identity in an inauthentic, unchallenging
   manner, which caters solely to those in power (namely rich, white, cisgender,
   heterosexual men). Seeking professionalism is *antithetical* to the goal of
   equity, and thus, these guidelines reject it.
    - Attempting to suppress self-expression or non-harmful speech is not
      acceptable for any reason.
    - There will be queers, punks, femboys, drag queens, furries, hackers,
      kinksters, and all sorts of other people here. And the project will
      reflect that. If you don't like this, consider looking for Free Software
      projects
      [elsewhere](https://loose-files.keithhacks.cyou/img/trashcan.jpg).

2. **Treat individuals with respect.** Differing experiences and viewpoints
   deserve to be respected, and bigotry and harassment are not tolerated under
   any circumstances.
    - Individuals should never be made to feel unsafe or unvalued due to their
      age, gender, sexuality, race, ethnicity, disability, religion, appearance,
      education, level of expertise, or other factors.
    - Behaviour that is harmful in nature should be addressed and corrected
      *regardless of intent*.
    - Respect personal boundaries and ask for clarification whenever they are
      unclear.
    - (Obviously, hate does not count as merely a "differing viewpoint", because
      it is harmful in nature.)

3. **Be understanding of differences in communication.** Not everyone is aware
   of unspoken social cues, and speech that is not intended to be offensive
   should not be treated as such simply due to an atypical manner of
   communication.
    - Somebody who speaks bluntly is not necessarily rude, and somebody who
      swears a lot is not necessarily volatile.
    - Try to confirm your interpretation of their intent rather than assuming
      bad faith.

4. **"Uncomfortable" does not mean "unsafe".** In an ideal world, the community
   would be safe, equitable, enjoyable, *and* comfortable for all members at all
   times. Unfortunately, this is not always possible in reality.
    - Safety and equity will be prioritized over comfort whenever it is
      necessary to do so.
    - Weaponizing one's own discomfort to deflect accountability or censor an
      individual (e.g. "white fragility") is a form of discriminatory conduct.

5. **Let people grow from their mistakes.** Nobody is perfect; even the most
   well-meaning individual can do something hurtful. Everyone should be given a
   fair opportunity to explain themselves and correct their
   behaviour. Portraying someone as inherently malicious prevents improvement
   and shifts focus away from the *action* that was problematic.
    - Avoid bringing up past events that do not accurately reflect an
      individual's current actions or beliefs. (This is, of course, different
      from providing evidence of a recurring pattern of behaviour.)

6. **No AI-generated code.**  Code that goes into Benben itself cannot be
   generated by LLMs.  Obviously you can't control what happens in third-party
   libraries, but the code that goes into Benben must have been written by a
   human to the best of the developers' knowledge.

---
This document was created by ~keith as part of its default repository template,
and is licensed under CC-BY-SA 4.0.  It has been modified by Remilia
Scarlet. The original template is here:
<https://bytes.keithhacks.cyou/keith/default-template>
