#ifndef SlotItem_H
#define SlotItem_H
/*
 * Copyright 2022, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */

// base.a
#include <base/allocator.h>  // member
#include <util/string.h>  // member
#include <util/list.h>  // Ancestor


class KeyValPair : public Genode::List<KeyValPair>::Element
{
public:
		KeyValPair(
			const char * key,
			const char * value
			);

public: ///private:  // Data

		Genode::String<64> key;
		Genode::String<256> value;

private:

		/*
		 * Noncopyable
		 */
		KeyValPair(KeyValPair const &);
		KeyValPair &operator = (KeyValPair const &);
};


class SlotItem : public Genode::List<KeyValPair>
{
	// Slot extracted from within SlotIO:
	// A filename+attributes temporarily extracted (and laid out in memory)
	// from within the plain-text-serialized SlotIO representation.

public:

		SlotItem( Genode::Allocator & alloc );
		~SlotItem();
		
		bool HasAttr( const char * attrname ) const;
		unsigned CountAttrs() const;
		const char * FullPath() const;
		
		void Clear();
		void SetFullpath( const char * newpath, unsigned str_len );
		void SetAttr( const char * attrname, const char * val );
		void DeleteAttr( const char * attrname );
		
		bool MatchesPredicate( const char * predicate ) const;


private:  // Types

	typedef Genode::String<2 + sizeof('\0')>   StrOperator;
	typedef Genode::String<64>  StrName;
	typedef Genode::String<256> StrValue;


private:  // Code

		bool recursParenthese( const char * cur_pos ) const;
		bool getActualValue(
			const StrName wanted_attr,
			StrValue & into_actual_value
			) const;
		bool applyOperator(
			const StrOperator & ope,
			const StrValue & wanted_value,
			const StrValue & actual_value
			) const;
		bool matchString(
			const StrValue & actual_value,
			const StrOperator & ope,
			const StrValue & wanted_value
			) const;


private:  // Data

		// key-value pairs:
		// -> inherited
		
		// file path:
		Genode::String<256/*B_FILE_NAME_LENGTH*/> fullPath;
		
		Genode::Allocator & memHeap;


private:
		/*
		 * Noncopyable
		 */
		SlotItem(SlotItem const &);
		SlotItem &operator = (SlotItem const &);
};


#endif // SlotItem_H

