#ifndef SlotIO_H
#define SlotIO_H
/*
 * Copyright 2022, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */

// base.a
#include <base/allocator.h>  // member

// project
#include "BufIO.h"  // Ancestor
class SlotItem;



class SlotIO : private BufIO
{
	typedef BufIO inherited;
	
public:

		SlotIO( Genode::Allocator & alloc );
		
		// inherited: global getters
		using BufIO::Dump, BufIO::Buffer, BufIO::BufferLength;
		
		// Global access
		//
		
		void SetAs( const void * index_contents, unsigned size );
		void CheckIntegrity();
		
		
		// Iterative (machine-state) parsing/access
		//
		
		// ... state-iterators
		bool Rewind();
		bool NextSlot();
		bool FindByFullpath( const char * fullpath );
		
		// ... getters
		void GetCurrentSlot( SlotItem & into );
		
		// ... setters
		void RemoveCurrentSlot();
		void AppendSlot( const SlotItem & slot );
		

private:  // Code

		const char * curLine() const;
		unsigned curLineSize() const;
		

private:  // Data

		// index data
		// -> inherited BufIO
		
		// current position
		unsigned curByte;
};


#endif // SlotIO_H

